/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.pride;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.yumi.mc.core.api.YumiMods;
import io.github.queerbric.pride.PrideFlag;
import io.github.queerbric.pride.PrideFlags;
import io.github.queerbric.pride.shape.PrideFlagShape;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrideLoader
extends class_4080<List<PrideFlag>> {
    public static final class_2960 ID = class_2960.method_60655((String)"pride", (String)"flags");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"pride");
    private static final Gson GSON = new Gson();

    @NotNull
    public class_2960 id() {
        return ID;
    }

    public List<PrideFlag> prepare(class_3300 manager, class_3695 profiler) {
        return PrideLoader.loadFlags(manager);
    }

    public void apply(List<PrideFlag> list, class_3300 manager, class_3695 profiler) {
        PrideLoader.applyFlags(list);
    }

    public static List<PrideFlag> loadFlags(class_3300 manager) {
        ArrayList<PrideFlag> flags = new ArrayList<PrideFlag>();
        for (Map.Entry entry : manager.method_14488("flags", path -> path.method_12832().endsWith(".json")).entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            String[] parts = id.method_12832().split("/");
            String name = parts[parts.length - 1];
            name = name.substring(0, name.length() - 5);
            try (InputStreamReader reader = new InputStreamReader(((class_3298)entry.getValue()).method_14482());){
                JsonElement rawJson = JsonParser.parseReader((Reader)reader);
                if (!rawJson.isJsonObject()) {
                    LOGGER.warn("[pride] Failed to pride flag \"{}\". Expected JSON object in file.", (Object)id);
                    continue;
                }
                DataResult loaded = PrideFlagShape.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)rawJson);
                loaded.ifError(error -> LOGGER.warn("[pride] Failed to load pride flag \"{}\" due to error: {}", (Object)id, (Object)error.message()));
                Optional result = loaded.result();
                if (!result.isPresent()) continue;
                flags.add(new PrideFlag(name, (PrideFlagShape)result.get()));
            }
            catch (Exception e) {
                LOGGER.warn("[pride] Malformed flag data for flag {}", (Object)name, (Object)e);
            }
        }
        Path pridePath = YumiMods.get().getConfigDirectory().resolve("pride.json");
        if (Files.exists(pridePath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(pridePath);){
                Config config = (Config)GSON.fromJson((Reader)reader, Config.class);
                if (config.flags != null) {
                    List<String> list = Arrays.asList(config.flags);
                    flags.removeIf(flag -> !list.contains(flag.getId()));
                }
            }
            catch (Exception e) {
                LOGGER.warn("[pride] Malformed flag data for pride.json config");
            }
        } else {
            class_2960 id = class_2960.method_60655((String)"pride", (String)"flags.json");
            Optional resource = manager.method_14486(id);
            if (resource.isPresent()) {
                try (InputStreamReader reader = new InputStreamReader(((class_3298)resource.get()).method_14482());){
                    Config config = (Config)GSON.fromJson((Reader)reader, Config.class);
                    if (config.flags != null) {
                        List<String> list = Arrays.asList(config.flags);
                        flags.removeIf(flag -> !list.contains(flag.getId()));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("[pride] Malformed flag data for flags.json", (Throwable)e);
                }
            }
        }
        return flags;
    }

    private static void applyFlags(List<PrideFlag> flags) {
        PrideFlags.setFlags(flags);
    }

    static class Config {
        String[] flags;

        Config() {
        }
    }
}

